from header_particle_systems import *
#psf_always_emit         = 0x0000000002
#psf_global_emit_dir     = 0x0000000010
#psf_emit_at_water_level = 0x0000000020
#psf_billboard_2d        = 0x0000000100 # up_vec = dir, front rotated towards camera
#psf_billboard_3d        = 0x0000000200 # front_vec point to camera.
#psf_turn_to_velocity    = 0x0000000400
#psf_randomize_rotation  = 0x0000001000
#psf_randomize_size      = 0x0000002000
#psf_2d_turbulance       = 0x0000010000

####################################################################################################################
#   Each particle system contains the following fields:
#  
#  1) Particle system id (string): used for referencing particle systems in other files.
#     The prefix psys_ is automatically added before each particle system id.
#  2) Particle system flags (int). See header_particle_systems.py for a list of available flags
#  3) mesh-name.
####
#  4) Num particles per second:    Number of particles emitted per second.
#  5) Particle Life:    Each particle lives this long (in seconds).
#  6) Damping:          How much particle's speed is lost due to friction.
#  7) Gravity strength: Effect of gravity. (Negative values make the particles float upwards.)
#  8) Turbulance size:  Size of random turbulance (in meters)
#  9) Turbulance strength: How much a particle is affected by turbulance.
####
# 10,11) Alpha keys :    Each attribute is controlled by two keys and 
# 12,13) Red keys   :    each key has two fields: (time, magnitude)
# 14,15) Green keys :    For example scale key (0.3,0.6) means 
# 16,17) Blue keys  :    scale of each particle will be 0.6 at the
# 18,19) Scale keys :    time 0.3 (where time=0 means creation and time=1 means end of the particle)
#
# The magnitudes are interpolated in between the two keys and remain constant beyond the keys.
# Except the alpha always starts from 0 at time 0.
####
# 20) Emit Box Size :   The dimension of the box particles are emitted from.
# 21) Emit velocity :   Particles are initially shot with this velocity.
# 22) Emit dir randomness
# 23) Particle rotation speed: Particles start to rotate with this (angular) speed (degrees per second).
# 24) Particle rotation damping: How quickly particles stop their rotation
####################################################################################################################

particle_systems = [
  
  ("game_rain", psf_always_emit|psf_global_emit_dir|psf_billboard_2d|psf_billboard_drop, "prtcl_rain",
    500, 0.5, 0.33, 1, 10, 0,
    (1, 0.3), (1, 0.3),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (8.2, 8.2, 0.2),
    (0, 0, -10),
    0,
    0, 0.5
  ),

  ("game_snow", psf_always_emit|psf_global_emit_dir|psf_billboard_2d|psf_billboard_drop, "prtcl_rain",
    500, 0.5, 0.33, 1, 10, 0,
    (1, 0.3), (1, 0.3),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (8.2, 8.2, 0.2),
    (0, 0, -10),
    0,
    0, 0.5
  ),

##    ("game_blood", psf_billboard_3d|psf_randomize_size|psf_randomize_rotation, "prtcl_dust_a",
##     50, 0.65, 0.95, 1.0, 10.0, 0.0,     #num_particles, life, damping, gravity_strength, turbulance_size, turbulance_strength
##     (0.3, 0.3), (1, 0.2),        #alpha keys
##     (1.0, 0.4), (1, 0.05),      #red keys
##     (1.0, 0.05),(1, 0.05),      #green keys
##     (1.0, 0.05),(1, 0.05),      #blue keys
##     (0.3, 0.5),   (1.0, 2.5),   #scale keys
##     (0.04, 0.01, 0.01),           #emit box size
##     (0, 1, 0.0),               #emit velocity
##     0.05,                       #emit dir randomness
##     0,                       #rotation speed
##     0.5                        #rotation damping
##    ),
##    
    ("game_blood", psf_billboard_3d |psf_randomize_size|psf_randomize_rotation,  "prt_mesh_blood_2", #hispania 1200
     500, 0.7, 3, 1, 6, 0,        #num_particles, life, damping, gravity_strength, turbulance_size, turbulance_strength
     (0.0, 0.7), (0.7, 0.7),          #alpha keys
     (0.1, 0.7), (1, 0.7),      #red keys
     (0.1, 0.7), (1, 0.7),       #green keys
     (0.1, 0.7), (1, 0.7),      #blue keys
     (0.0, 0.015),   (1, 0.5),  #scale keys
     (0, 0.5, 0),               #emit box size
     (0.5, 1.0, 0.3),                #emit velocity
     0.9,                       #emit dir randomness
     0,                         #rotation speed
     0,                         #rotation damping
    ),
    ("game_blood_2", psf_billboard_3d | psf_randomize_size|psf_randomize_rotation ,  "prt_mesh_blood_3", #hispania 1200
      2000, 0.6, 3, 1, 6, 0,        #num_particles, life, damping, gravity_strength, turbulance_size, turbulance_strength
     (0.0, 0.25), (0.7, 0.1),        #alpha keys
     (0.1, 0.7), (1, 0.7),      #red keys
     (0.1, 0.7), (1, 0.7),       #green keys
     (0.1, 0.7), (1, 0.7),      #blue keys
     (0.0, 0.15),   (1, 0.6),    #scale keys
     (0.01, 0.2, 0.01),             #emit box size
     (0.5, 1.0, 0.3),                 #emit velocity
     0.9,                         #emit dir randomness
     150,                       #rotation speed
     0,                       #rotation damping
     ),

  ("game_hoof_dust", psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size|psf_2d_turbulance, "prt_mesh_dust_1",
    6, 8, 10, 0.01, 10, 39,
    (0.1, 0.9), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 2), (1, 9.5),
    (0.6, 0.9, 0.6),
    (0, 0, 3.9),
    0.5,
    130, 0.5
  ),

  ("game_hoof_dust_snow", psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size|psf_2d_turbulance, "prt_mesh_dust_1",
    6, 8, 10, 0.01, 10, 39,
    (0.1, 0.9), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 2), (1, 9.5),
    (0.6, 0.9, 0.6),
    (0, 0, 3.9),
    0.5,
    130, 0.5
  ),

  ("game_hoof_dust_mud", psf_billboard_2d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size|psf_2d_turbulance, "prt_mesh_mud_1",
    300, 9, 1, 3, 2, 0,
    (0, 1), (1, 1),
    (0, 0.7), (1, 0.7),
    (0, 0.6), (1, 0.6),
    (0, 0.4), (1, 0.4),
    (0, 0.2), (1, 0.22),
    (0.15, 0.5, 0.1),
    (0, 0, 15),
    6,
    200, 0.5
  ),

  ("game_water_splash_1", psf_emit_at_water_level|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prtcl_drop",
    20, 0.85, 0.25, 0.9, 10, 0,
    (0.3, 0.5), (1, 0),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (0, 0.3), (1, 0.18),
    (0.3, 0.2, 0.1),
    (0, 1.2, 2.3),
    0.3,
    50, 0.5
  ),

  ("game_water_splash_2", psf_emit_at_water_level|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prtcl_splash_b",
    30, 0.4, 0.7, 0.5, 10, 0,
    (0.3, 1), (1, 0.3),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (0, 0.25), (1, 0.7),
    (0.4, 0.3, 0.1),
    (0, 1.3, 1.1),
    0.1,
    50, 0.5
  ),

  ("game_water_splash_3", psf_emit_at_water_level, "prt_mesh_water_wave_1",
    5, 2, 0, 0, 10, 0,
    (0.03, 0.2), (1, 0),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (0, 3), (1, 10),
    (0, 0, 0),
    (0, 0, 0),
    0,
    0, 0.5
  ),

  ("torch_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    50, 0.35, 0.2, 0.03, 10, 0,
    (0.5, 0.8), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0, 0.15), (0.4, 0.3),
    (0.04, 0.04, 0.01),
    (0, 0, 0.5),
    0,
    200, 0.5
  ),

  ("fire_glow_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_mesh_fire_2",
    2, 0.55, 0.2, 0, 10, 0,
    (0.5, 0.9), (1, 0),
    (0, 0.9), (1, 0.9),
    (0, 0.7), (1, 0.7),
    (0, 0.4), (1, 0.4),
    (0, 2), (1, 2),
    (0, 0, 0),
    (0, 0, 0),
    0,
    0, 0
  ),

  ("fire_glow_fixed", psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_mesh_fire_2",
    4, 100, 0.2, 0, 10, 0,
    (-0.01, 1), (1, 1),
    (0, 0.9), (1, 0.9),
    (0, 0.7), (1, 0.7),
    (0, 0.4), (1, 0.4),
    (0, 2), (1, 2),
    (0, 0, 0),
    (0, 0, 0),
    0,
    0, 0
  ),

  ("torch_smoke", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prtcl_dust_a",
    15, 0.5, 0.2, -0.2, 10, 0.1,
    (0.5, 0.25), (1, 0),
    (0, 0.2), (1, 0.1),
    (0, 0.2), (1, 0.09),
    (0, 0.2), (1, 0.08),
    (0, 0.5), (0.8, 2.5),
    (0.1, 0.1, 0.1),
    (0, 0, 1.5),
    0.1,
    0, 0
  ),

  ("flue_smoke_short", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prtcl_dust_a",
    15, 1.5, 0.1, 0, 10, 12,
    (0, 0.3), (1, 0),
    (0, 0.2), (1, 0.1),
    (0, 0.2), (1, 0.09),
    (0, 0.2), (1, 0.08),
    (0, 1.5), (1, 7),
    (0, 0, 0),
    (0, 0, 1.5),
    0.1,
    150, 0.8
  ),

  ("flue_smoke_tall", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prtcl_dust_a",
    15, 3, 0.5, 0, 15, 12,
    (0, 0.35), (1, 0),
    (0, 0.3), (1, 0.1),
    (0, 0.3), (1, 0.1),
    (0, 0.3), (1, 0.1),
    (0, 2), (1, 7),
    (0, 0, 0),
    (0, 0, 1.5),
    0.1,
    150, 0.5
  ),

  ("war_smoke_tall", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_smoke_1",
    5, 12, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 2.2), (1, 15),
    (0, 0, 0),
    (0, 0, 2.2),
    0.1,
    100, 0.2
  ),

  ("ladder_dust_6m", psf_billboard_3d|psf_billboard_drop, "prt_mesh_smoke_1",
    700, 0.9, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 2),
    (0.75, 0.75, 3.5),
    (0, 0, 0),
    0.1,
    100, 0.2
  ),

  ("ladder_dust_8m", psf_billboard_3d|psf_billboard_drop, "prt_mesh_smoke_1",
    900, 0.9, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 2),
    (0.75, 0.75, 4.5),
    (0, 0, 0),
    0.1,
    100, 0.2
  ),

  ("ladder_dust_10m", psf_billboard_3d|psf_billboard_drop, "prt_mesh_smoke_1",
    1100, 0.9, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 2),
    (0.75, 0.75, 5.5),
    (0, 0, 0),
    0.1,
    100, 0.2
  ),

  ("ladder_dust_12m", psf_billboard_3d|psf_billboard_drop, "prt_mesh_smoke_1",
    1300, 0.9, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 2),
    (0.75, 0.75, 6.5),
    (0, 0, 0),
    0.1,
    100, 0.2
  ),

  ("ladder_dust_14m", psf_billboard_3d|psf_billboard_drop, "prt_mesh_smoke_1",
    1500, 0.9, 0, 0, 7, 7,
    (0, 0.25), (1, 0),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 0.8),
    (0, 1), (1, 2),
    (0.75, 0.75, 7.5),
    (0, 0, 0),
    0.1,
    100, 0.2
  ),

  ("ladder_straw_6m", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    700, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.75, 0.75, 3.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("ladder_straw_8m", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    900, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.75, 0.75, 4.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("ladder_straw_10m", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    1100, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.75, 0.75, 5.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("ladder_straw_12m", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    1300, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.75, 0.75, 6.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("ladder_straw_14m", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    1500, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.75, 0.75, 7.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("torch_fire_sparks", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_sparks_mesh_1",
    10, 0.7, 0.2, 0, 10, 0.02,
    (0.66, 1), (1, 0),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.1), (1, 0.1),
    (0.1, 0.05), (1, 0.05),
    (0.1, 0.1, 0.1),
    (0, 0, 0.9),
    0,
    0, 0
  ),

  ("fire_sparks_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_sparks_mesh_1",
    10, 1.5, 0.2, 0, 3, 10,
    (0.6, 1), (1, 1),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.1), (1, 0.1),
    (0.1, 0.07), (1, 0.03),
    (0.17, 0.17, 0.01),
    (0, 0, 1),
    0,
    0, 0
  ),

  ("pistol_smoke", psf_billboard_3d|psf_billboard_drop, "prtcl_dust_a",
    90, 2.5, 0.6, -0.2, 60, 1.5,
    (0, 0.75), (1, 0),
    (0, 0.7), (1, 0.4),
    (0, 0.7), (1, 0.4),
    (0, 0.7), (1, 0.4),
    (0, 1.5), (0.5, 11),
    (0.1, 0.1, 0.1),
    (2, 2, 0),
    0.1,
    0, 0
  ),

  ("brazier_fire_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    25, 0.5, 0.1, 0, 10, 0,
    (0.5, 0.4), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0.1, 0.2), (1, 0.5),
    (0.1, 0.1, 0.01),
    (0, 0, 0.4),
    0,
    100, 0.2
  ),

  ("cooking_fire_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    25, 0.35, 0.1, 0.03, 10, 0,
    (0.5, 0.8), (1, 0),
    (0.5, 0.5), (1, 0.27),
    (0.5, 0.35), (1, 0.09),
    (0.5, 0.1), (1, 0),
    (0.1, 0.5), (1, 1),
    (0.05, 0.05, 0.01),
    (0, 0, 1),
    0,
    200, 0
  ),

  ("cooking_smoke", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_smoke_1",
    4, 4, 0.1, 0, 3, 5,
    (0.2, 0.2), (1, 0),
    (0, 0.8), (1, 1),
    (0, 0.8), (1, 1),
    (0, 0.85), (1, 1),
    (0, 0.65), (1, 3),
    (0, 0, 0),
    (0, 0, 1.2),
    0,
    0, 0
  ),

  ("food_steam", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_steam_1",
    3, 1, 0, 0, 8, 1,
    (0.5, 0.1), (1, 0),
    (0, 1), (1, 0.1),
    (0, 1), (1, 0.1),
    (0, 1), (1, 0.1),
    (0, 0.2), (0.9, 0.5),
    (0.05, 0.05, 0),
    (0, 0, 0.1),
    0,
    100, 0.5
  ),

  ("candle_light", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_mesh_candle_fire_1",
    7, 1.1, 0.6, 0, 10, 0.2,
    (0.1, 0.5), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.6), (1, 0.1),
    (0.5, 0.2), (1, 0),
    (0.3, 0.2), (1, 0),
    (0, 0, 0),
    (0, 0, 0.09),
    0,
    0, 0
  ),

  ("candle_light_small", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_mesh_candle_fire_1",
    4, 1.1, 0.6, 0, 10, 0.2,
    (0.1, 0.8), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.6), (1, 0.1),
    (0.5, 0.2), (1, 0),
    (0.3, 0.13), (1, 0),
    (0, 0, 0),
    (0, 0, 0.06),
    0,
    0, 0
  ),

  ("lamp_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    10, 0.8, 0.6, 0, 10, 0.4,
    (0.1, 0.5), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.8), (1, 0.1),
    (0.5, 0.4), (1, 0),
    (0.3, 0.35), (0.9, 0.5),
    (0.01, 0.01, 0),
    (0, 0, 0.35),
    0.03,
    100, 0.5
  ),

  ("dummy_smoke", psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_mesh_dust_1",
    500, 3, 15, -0.05, 10, 0.2,
    (0.1, 0.5), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 0.7), (1, 2.2),
    (0.2, 0.2, 0.5),
    (0, 0, 0.05),
    2,
    10, 0.1
  ),

  ("dummy_straw", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    500, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.3), (1, 0.3),
    (0.2, 0.2, 0.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("dummy_smoke_big", psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_mesh_dust_1",
    500, 9, 15, -0.05, 10, 0.2,
    (0.1, 0.9), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 5), (1, 15),
    (3, 3, 5),
    (0, 0, 0.05),
    2,
    10, 0.1
  ),

  ("dummy_straw_big", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    500, 3, 2, 2, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.8), (1, 0.8),
    (3, 3, 3),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("gourd_smoke", psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_mesh_dust_1",
    500, 3, 15, -0.05, 10, 0.2,
    (0.1, 0.5), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 0.5), (1, 1),
    (0.2, 0.2, 0.5),
    (0, 0, 0.05),
    2,
    10, 0.1
  ),

  ("gourd_piece_1", psf_randomize_rotation, "prt_gourd_piece_1",
    15, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 1), (1, 1),
    (0.2, 0.2, 0.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("gourd_piece_2", psf_randomize_rotation|psf_randomize_size, "prt_gourd_piece_2",
    50, 1, 2, 0.9, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 1), (1, 1),
    (0.2, 0.2, 0.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("fire_fly_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_sparks_mesh_1",
    2, 5, 1.2, 0, 50, 7,
    (0.1, 0.8), (1, 0.2),
    (0.5, 0.7), (1, 0.7),
    (0.5, 0.8), (1, 0.8),
    (0.5, 1), (1, 1),
    (0, 0.1), (1, 0.1),
    (20, 20, 0.5),
    (0, 0, 0),
    5,
    0, 0
  ),

  ("bug_fly_1", psf_always_emit|psf_billboard_2d|psf_billboard_drop, "prt_mesh_rose_a",
    20, 8, 0.02, 0.025, 1, 5,
    (0, 1), (1, 1),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.25), (1, 0.25),
    (10, 5, 0.1),
    (0, 0, -0.9),
    0.01,
    10, 0
  ),

  ("moon_beam_1", psf_always_emit|psf_global_emit_dir|psf_billboard_2d|psf_billboard_drop|psf_randomize_size, "prt_mesh_moon_beam",
    2, 4, 1.2, 0, 0, 0,
    (0.5, 1), (1, 0),
    (0, 0.4), (1, 0.4),
    (0, 0.5), (1, 0.5),
    (0, 0.6), (1, 0.6),
    (0, 2), (1, 2.2),
    (1, 1, 0.2),
    (0, 0, -2),
    0,
    100, 0.5
  ),

  ("moon_beam_paricle_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_sparks_mesh_1",
    10, 1.5, 1.5, 0, 10, 10,
    (0.5, 1), (1, 0),
    (0.5, 0.5), (1, 0.5),
    (0.5, 0.7), (1, 0.7),
    (0.5, 1), (1, 1),
    (0, 0.1), (1, 0.1),
    (1, 1, 4),
    (0, 0, 0),
    0.5,
    0, 0
  ),

  ("night_smoke_1", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop, "prt_mesh_dust_1",
    5, 10, 1.5, 0, 50, 2,
    (0.3, 0.1), (1, 0),
    (0.5, 0.5), (1, 0.5),
    (0.5, 0.5), (1, 0.5),
    (0.5, 0.5), (1, 0.6),
    (0, 10), (1, 10),
    (25, 25, 0.5),
    (0, 1, 0),
    2,
    20, 1
  ),

  ("fireplace_fire_small", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    25, 0.8, 0.2, -0.1, 10, 0,
    (0.5, 0.5), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0, 0.2), (1, 0.7),
    (0.2, 0.1, 0.01),
    (0, 0, 0.2),
    0.1,
    100, 0.5
  ),

  ("fireplace_fire_big", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    35, 0.6, 0.2, -0.2, 10, 0,
    (0.5, 0.5), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0, 0.4), (1, 1),
    (0.4, 0.2, 0.01),
    (0, 0, 0.4),
    0.1,
    100, 0.5
  ),

  ("village_fire_big", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    50, 1, 0, -1.2, 25, 10,
    (0.2, 0.7), (1, 0),
    (0.2, 1), (1, 0.9),
    (0.2, 0.7), (1, 0.3),
    (0.2, 0.2), (1, 0),
    (0, 2), (1, 6),
    (2.2, 2.2, 0.2),
    (0, 0, 0),
    0,
    250, 0.3
  ),

  ("village_fire_smoke_big", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_smoke_1",
    30, 2, 0.3, -1, 50, 10,
    (0.5, 0.15), (1, 0),
    (0.2, 0.4), (1, 0.2),
    (0.2, 0.4), (1, 0.2),
    (0.2, 0.4), (1, 0.2),
    (0, 6), (1, 8),
    (2, 2, 1),
    (0, 0, 5),
    0,
    0, 0.1
  ),

  ("map_village_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    20, 1, 0, -0.2, 3, 3,
    (0.2, 0.7), (1, 0),
    (0.2, 1), (1, 0.9),
    (0.2, 0.7), (1, 0.3),
    (0.2, 0.2), (1, 0),
    (0, 0.15), (1, 0.45),
    (0.2, 0.2, 0.02),
    (0, 0, 0),
    0,
    250, 0.3
  ),

  ("map_village_fire_smoke", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_smoke_1",
    25, 2.5, 0.3, -0.15, 3, 3,
    (0.5, 0.15), (1, 0),
    (0.2, 0.4), (1, 0.3),
    (0.2, 0.4), (1, 0.3),
    (0.2, 0.4), (1, 0.3),
    (0, 0.6), (1, 0.9),
    (0.2, 0.2, 0.1),
    (0, 0, 0.03),
    0,
    0, 0.1
  ),

  ("map_village_looted_smoke", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_smoke_1",
    20, 3, 0.3, -0.11, 3, 2,
    (0.5, 0.15), (1, 0),
    (0.2, 0.5), (1, 0.5),
    (0.2, 0.5), (1, 0.5),
    (0.2, 0.5), (1, 0.5),
    (0, 0.7), (1, 1.3),
    (0.2, 0.2, 0.1),
    (0, 0, 0.015),
    0,
    0, 0.1
  ),

  ("dungeon_water_drops", psf_always_emit|psf_global_emit_dir|psf_billboard_2d|psf_billboard_drop, "prtcl_rain",
    1, 1, 0.33, 0.8, 0, 0,
    (1, 0.2), (1, 0.2),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 0.8), (1, 0.8),
    (0.05, 0.05, 0.5),
    (0, 0, -5),
    0,
    0, 0
  ),

  ("wedding_rose", psf_always_emit|psf_billboard_2d|psf_billboard_drop, "prt_mesh_rose_a",
    50, 8, 0.02, 0.025, 1, 5,
    (0, 1), (1, 1),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.25), (1, 0.25),
    (4, 4, 0.1),
    (0, 0, -0.9),
    0.01,
    10, 0
  ),

  ("sea_foam_a", psf_always_emit|psf_turn_to_velocity|psf_randomize_size, "prt_foam_a",
    1, 3, 1, 0, 0, 0,
    (0.7, 0.1), (1, 0),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (1, 1), (1, 1),
    (0, 4), (1, 4.5),
    (10, 1, 0),
    (0, 1, 0),
    0,
    0, 0.5
  ),

  ("fall_leafs_a", psf_always_emit|psf_billboard_2d|psf_billboard_drop, "prt_mesh_yrellow_leaf_a",
    1, 9, 0, 0.025, 4, 4,
    (0, 1), (1, 1),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.25), (1, 0.25),
    (4, 4, 4),
    (0, 0.01, -0.9),
    0.02,
    15, 0
  ),

  ("massive_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    50, 1.5, 0.1, -0.2, 25, 5,
    (0.2, 0.7), (1, 0),
    (0.2, 1), (1, 0.9),
    (0.2, 0.7), (1, 0.3),
    (0.2, 0.2), (1, 0),
    (0, 1), (1, 3),
    (0.5, 0.5, 0.1),
    (0, 0, 0),
    0.3,
    250, 0.3
  ),

  ("greek_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    50, 0.2, 0.2, 0, 10, 0,
    (0.1, 0.5), (0.9, 0),
    (0.3, 1), (1, 0.9),
    (0.3, 0.7), (1, 0.3),
    (0.3, 0.2), (1, 0),
    (0, 0.35), (1, 0.35),
    (0.04, 0.04, 0.01),
    (0.1, 0.1, 0.1),
    0.1,
    200, 0.5
  ),

  ("ship_smoke", psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_mesh_dust_1",
    500, 2, 15, -0.05, 10, 0.2,
    (0.1, 0.5), (1, 0),
    (0.1, 0.8), (1, 0.8),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.6), (1, 0.7),
    (0, 7), (10, 22),
    (2, 2, 5),
    (0, 0, 0.5),
    2,
    10, 0.1
  ),

  ("ship_shrapnel", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    5000, 1, 2, 1.5, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 1.5), (5, 1.5),
    (2, 2, 5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("greek_fire", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    100, 0.35, 0.2, 0.03, 10, 0,
    (0.5, 0.8), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0, 1.5), (4, 3),
    (0.04, 0.04, 0.01),
    (0, 0, 0.5),
    0,
    200, 0.5
  ),

  ("wake", psf_always_emit|psf_emit_at_water_level, "prt_mesh_water_wave_1",
    4, 10, 0, 0, 10, 0,
    (0.03, 0.2), (1, 0),
    (0.3, 0.3), (0.3, 0.3),
    (0.3, 0.3), (0.3, 0.3),
    (0.3, 0.3), (0.3, 0.3),
    (0, 30), (100, 1000),
    (0, 0, 0),
    (0, 0, 0),
    0,
    0, 0.5
  ),

  ("torch_fire2", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_fire_1",
    50, 2, 0.01, 0.03, 10, 0,
    (0.5, 0.8), (1, 0),
    (0.5, 1), (1, 0.9),
    (0.5, 0.7), (1, 0.3),
    (0.5, 0.2), (1, 0),
    (0, 0.15), (0.4, 0.3),
    (0.04, 0.04, 0.01),
    (0, 0, 0.5),
    0,
    200, 0.5
  ),

  ("map_party_go", psf_always_emit|psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_dust_1",
    10, 1, 0, -0.005, 3, 3,
    (0.2, 0.7), (1, 0),
    (0.2, 1), (1, 0.9),
    (0.2, 0.7), (1, 0.3),
    (0.2, 0.2), (1, 0),
    (0, 0.15), (1, 0.45),
    (0.2, 0.2, 0.02),
    (0, 0, 0),
    0,
    250, 0.3
  ),

  ("lanse", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    2000, 3, 2, 0.7, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.8), (1, 0.8),
    (2.5, 2.5, 2.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("lanse_straw", psf_randomize_rotation|psf_randomize_size, "prt_mesh_straw_1",
    2000, 3, 2, 0.7, 10, 2,
    (0.1, 1), (1, 1),
    (0.1, 0.6), (1, 0.6),
    (0.1, 0.5), (1, 0.5),
    (0.1, 0.4), (1, 0.4),
    (0, 0.8), (1, 0.8),
    (2.5, 2.5, 2.5),
    (0, 0, 0),
    2.3,
    200, 0
  ),

  ("lanse_blood", psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prt_mesh_blood_3",
    2000, 0.6, 3, 0.3, 0, 0,
    (0, 0.25), (0.7, 0.1),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.7), (1, 0.7),
    (0.1, 0.4), (0.5, 0.35),
    (1.2, 1.2, 1.2),
    (0.4, 0.4, 0),
    0.3,
    150, 0
  ),

  ("desert_storm_old", psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size|psf_2d_turbulance, "prt_mesh_dust_1",
    1550, 0.3, 10, 0.05, 10, 39,
    (0.2, 0.5), (1, 0),
    (3, 1), (5, 1),
    (3, 0.9), (5, 0.9),
    (3, 0.78), (5, 0.78),
    (5, 8), (3, 10),
    (10, 4, 3),
    (0, 0, 0.4),
    0.5,
    130, 0.5
  ),

  ("desert_storm", psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size|psf_2d_turbulance, "prt_mesh_dust_1",
    1550, 5.3, 10, 1.05, 10, 39,
    (0.2, 0.5), (1, 0),
    (3, 1), (5, 1),
    (3, 0.9), (5, 0.9),
    (3, 0.78), (5, 0.78),
    (5, 8), (3, 10),
    (10, 4, 3),
    (0, 0, 0.4),
    0.5,
    130, 0.5
  ),

  ("water_hit_a", psf_global_emit_dir|psf_billboard_3d|psf_billboard_drop|psf_randomize_rotation|psf_randomize_size, "prtcl_splash_b",
    80, 1.5, 4, 0.8, 0, 0,
    (0, 1), (1, 0),
    (0, 0.95), (1, 0.95),
    (0, 0.9), (1, 0.9),
    (0, 0.7), (1, 0.7),
    (0, 0.3), (1, 2),
    (0, 0, 0),
    (0, 0, 6),
    0,
    100, 0.2
  ),

  ("water_hit_b", psf_global_emit_dir|psf_turn_to_velocity|psf_randomize_rotation|psf_randomize_size, "prtcl_splash_b",
    4, 3, 0, 0, 0, 0,
    (0, 1), (1, 0),
    (0, 0.95), (1, 0.95),
    (0, 0.9), (1, 0.9),
    (0, 0.7), (1, 0.7),
    (0, 1), (1, 5),
    (0.1, 0.1, 0),
    (0, 0, -0.01),
    0,
    25, 0.15
  ),

  ("hit_bird_feathers", psf_always_emit|psf_billboard_2d|psf_billboard_drop, "prt_bird_feathers",
    50, 20, 0.02, 0.025, 10, 5,
    (0, 1), (1, 1),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.5), (1, 0.5),
    (0, 0.25), (1, 0.25),
    (1.5, 1.5, 1.5),
    (0, 0, -0.9),
    0.1,
    10, 0.1
  ),

  ("hit_bird_blood", psf_billboard_3d|psf_billboard_drop|psf_randomize_size, "prt_mesh_dust_1",
    500, 3, 15, 0.1, 10, 0.2,
    (0.1, 0.5), (1, 0),
    (1, 0.4), (1, 0.05),
    (1, 0.05), (1, 0.05),
    (1, 0.05), (1, 0.05),
    (0, 0.7), (1, 2.2),
    (0.7, 0.7, 0.7),
    (0, 0, 0.05),
    2,
    10, 0.1
  ),

#corneilles
#    ("corneilles", 0 | psf_always_emit, "corneille",
#     1, 9, 0, 0.225, 0, 0,      #num_particles, life, damping, gravity_strength, turbulance_size, turbulance_strength
#     (0, 1), (1, 1),  ######          #alpha keys
#     (0, 0.5), (1, 0.5), ######       #red keys
#     (0, 0.5), (1, 0.5),######        #green keys
#     (0, 0.5), (1, 0.5),######        #blue keys
#     (0, 0.25),   (1, 0.25),######    #scale keys
#     (4, 4, 4),                 #emit box size
#     (0, 0.01, -0.9),           #emit velocity
#      0,                     #emit dir randomness
#      0,                       #rotation speed
#      0,                        #rotation damping
#    ),

#goeland
#    ("goeland", 0 | psf_always_emit, "mouete",
#     1, 9, 0, 0.225, 0, 0,      #num_particles, life, damping, gravity_strength, turbulance_size, turbulance_strength
#     (0, 1), (1, 1),  ######          #alpha keys
#     (0, 0.5), (1, 0.5), ######       #red keys
#     (0, 0.5), (1, 0.5),######        #green keys
#     (0, 0.5), (1, 0.5),######        #blue keys
#     (0, 0.25),   (1, 0.25),######    #scale keys
#     (4, 4, 4),                 #emit box size
#     (0, 0.01, -0.9),           #emit velocity
#      0,                     #emit dir randomness
#      0,                       #rotation speed
#      0,                        #rotation damping
#    ),  
  
]
# modmerger_start version=201 type=2
try:
    component_name = "particle_systems"
    var_set = { "particle_systems" : particle_systems }
    from modmerger import modmerge
    modmerge(var_set)
except:
    raise
# modmerger_end
